function [Tcal Tcal2] = ConfTable_CV(ycal,yprev_cal,ts)
% Rotina desenvolvida para calcular a tabela de confuso/contingencia do conjunto de
% amostras da calibrao
% INPUT : 
%          >ycal       Referncia das classes das amostras de calibrao
%          >yprev_cal  Valores previstos pelo modelo das amostras de calibrao
%          >ts         Limiares entre as classes
% OUTPUT:
%          > Tabela de confuso 1 e 2
          

YCAL = vet_matrix(ycal);
assignin('base','YCAL',YCAL);
assignin('base','yprev_cal',yprev_cal);
for lv = 1:size(yprev_cal,3)
%     for f = 1: size(ts,1)
        nc(:,:,lv)=yprev_cal(:,:,lv)-repmat(ts(end,:,lv),[size(yprev_cal,1),1]);
%     end
end

yprev_cal_new=[];
for lv = 1:size(yprev_cal,3) % max LV
    for i = 1:size(yprev_cal,1) % number of samples
        [ww,yprev_cal_new(i,lv)]=max(nc(i,:,lv));
    end
end

assignin('base','nc',nc);
assignin('base','yprev_cal_new',yprev_cal_new);

for lv = 1:size(yprev_cal_new,2) % max LV
    class_param_cal(lv) = calc_class_param(yprev_cal_new(:,lv),YCAL);
end
assignin('base','class_param_cal',class_param_cal);


% ----- Table of classes -----

% Extracting class classification for each column 
for c = 1:size(class_param_cal(1).conf_mat,1)
    columns(1,c) = sprintf("Class_%02d",c);      
    rows(c,1) = sprintf("Predicted as Class %02d",c);
end
columns(:,end+1) = 'Unassigned';
assignin('base','rows',rows)
assignin('base','columns',columns)

for LV = 1:size(class_param_cal,2)
    data = class_param_cal(LV).conf_mat; 
%     Table_classification{LV,1} = table(data,'RowNames', rows,'VariableNames',columns);
    Table_classification{LV,1} = table(data,'RowNames', rows);
end
% 
% for c = 1:size(class_param_cal(LV).conf_mat,1)       
%     rows = sprintf("Predicted as Class %02d",c);
% end
assignin('base','Table_classification',Table_classification)


return


C1=class_param_cal.conf_mat(:,1);
C2=class_param_cal.conf_mat(:,2);
C3=class_param_cal.conf_mat(:,3);
C4=class_param_cal.conf_mat(:,4);
% Unassigned=class_param_cal.conf_mat(:,end);
figmerit={'Classe_Orignal_Oliva','Classe_Orignal_Canola','Classe_Orignal_Milho','Classe_Orignal_Soja'};
Tcal=table(C1,C2,C3,C4,Sem_Classe,'RowNames',figmerit);

% ----- Tabela Precio para Excel -----

% Tcal.Properties.VariableNames = {'Previsto_Oliva','Previsto_Canola','Previsto_Milho','Previsto_Soja', 'Previsto_Sem_Classe'}
% writetable(Tcal,'Resultados_PLSDA.xlsx','Sheet',1,'Range','A1','WriteRowNames',true)
% clear C1 C2 C3 C4

C1=[class_param_cal.accuracy;class_param_cal.sensitivity(:,1);class_param_cal.specificity(:,1)];
C2=[class_param_cal.accuracy;class_param_cal.sensitivity(:,2);class_param_cal.specificity(:,2)];
C3=[class_param_cal.accuracy;class_param_cal.sensitivity(:,3);class_param_cal.specificity(:,3)];
C4=[class_param_cal.accuracy;class_param_cal.sensitivity(:,4);class_param_cal.specificity(:,4)];
figmerit={'Acurcia','Sensibilidade','Especificidade'};
Tcal2=table(C1,C2,C3,C4,'RowNames',figmerit)

% ----- Tabela Acuracia para Excel -----

% Tcal2.Properties.VariableNames = {'Azeite_de_Oliva','Oleo_de_Canola','Oleo_de_Milho','Oleo_de_Soja'}
% writetable(Tcal2,'Resultados_PLSDA.xlsx','Sheet',1,'Range','A8','WriteRowNames',true)

end
